@extends('layout.layout')

@php
    $route = 'users';
@endphp

@section('title', __('lang.users'))

@section('header')
    <h1 class="text-dark fw-bolder my-0 fs-2">{{ __('lang.users') }}</h1>

    <ul class="breadcrumb fw-bold fs-base my-1">
        <li class="breadcrumb-item">
            <a href="{{ url('/') }}" class="text-muted">{{ __('lang.Dashboard') }}</a>
        </li>
        <li class="breadcrumb-item">
            {{ __('lang.users') }}
        </li>
    </ul>
@endsection

@section('content')

<div id="kt_content_container" class="flex-column-fluid align-items-start container-xxl">

    <div class="content flex-row-fluid" id="kt_content">

        <div class="card">

            <div class="card-body pt-0">

                <div class="add_button1"></div>

                <div class="table-responsive">

                    <table class="table align-middle table-row-bordered text-start fs-4 gy-5" id="users_table">

                        <thead>

                        <tr class="bg-secondary text-dark fw-bolder fs-5 text-capitalize gs-0">
                            <th class="w-10px pe-2">
                                <div class="form-check form-check-sm form-check-custom form-check-solid me-3">
                                    <input class="form-check-input" type="checkbox"
                                           data-kt-check="true"
                                           data-kt-check-target="#users_table .checkbox"
                                           value="1"/>
                                </div>
                            </th>

                            <th class="min-w-125px">{{ __('lang.name') }}</th>
                            <th class="min-w-125px">{{ __('lang.email') }}</th>
                            <th class="min-w-125px">{{ __('lang.type') }}</th>
                            <th class="min-w-125px">{{ __('lang.active') }}</th>
                            <th class="min-w-125px">{{ __('lang.Actions') }}</th>
                        </tr>

                        </thead>

                    </table>

                </div>

            </div>

        </div>

    </div>

</div>

@endsection

@section('script')

<script src="{{ asset('assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>

<script>
    $(function () {

        var table = $('#users_table').DataTable({
            processing: true,
            serverSide: true,
            autoWidth: true,
            aaSorting: [],
            "dom":
                "<'card-header border-0 p-0 pt-6'<'card-title' <'d-flex align-items-center position-relative my-1'f>>" +
                "<'card-toolbar' <'d-flex justify-content-end add_button'B>>" +
                "r>" +
                "<'row'l>" +
                "t" +
                "<'row'<'col-md-5'i><'col-md-7'p>>",

            lengthMenu: [[10, 25, 50, 100, -1],
                         [10, 25, 50, 100, "{{ __('lang.all') }}"]],

            language: {
                search: '<i class="fa fa-search"></i>',
                searchPlaceholder: '{{ __("lang.search") }}',
                url: "@if(Session('lang') == 'ar') //cdn.datatables.net/plug-ins/1.13.6/i18n/ar.json @endif"
            },

            buttons: [
                {
                    extend: 'excel',
                    className: 'btn btn-primary',
                    text: '<i class="bi bi-file-earmark-spreadsheet-fill fs-2x"></i>',
                },
                {
                    extend: 'print',
                    className: 'btn btn-primary',
                    text: '<i class="bi bi-printer-fill fs-2x"></i>',
                }
            ],

            ajax: {
                    url: '{{ route($route . ".datatable") }}'
            },

            columns: [
                { data: 'checkbox', name: 'checkbox' },
                { data: 'name', name: 'name' },
                { data: 'email', name: 'email' },
                { data: 'role', name: 'role' },
                { data: 'is_active', name: 'is_active' },
                { data: 'actions', name: 'actions', orderable: false, searchable: false },
            ]
        });

        // Load add button
        $.ajax({
            url: "{{ route('users.add-button') }}",
            success: function (data) {
                $('.add_button1').html(data);
            }
        });


        // Change Active
        $(document).on('change', '.change-active', function () {
            let id = $(this).data('id');

            $.post(
                "{{ route('users.change_active') }}",
                { id: id, _token: "{{ csrf_token() }}" },
                function () { table.ajax.reload(); }
            );
        });

        // Delete
        $(document).on('click', '.delete-row', function () {
            let id = $(this).data('id');

            if (!confirm("{{ __('lang.confirm_delete') }}")) return;

            $.get("{{ route('users.delete') }}", { id: id }, function () {
                table.ajax.reload();
            });
        });

    });
</script>

@endsection
