<div class="fv-row mb-7">
    <label class="required fw-bold fs-6 mb-2">Site Name</label>
    <input type="text" name="name"
           class="form-control form-control-solid"
           value="{{ old('name', $data->name ?? '') }}" required>
</div>

<div class="fv-row mb-7">
    <label class="required fw-bold fs-6 mb-2">Domain</label>
    <input type="url" name="domain"
           class="form-control form-control-solid"
           value="{{ old('domain', $data->domain ?? '') }}" required>
</div>

<div class="fv-row mb-7">
    <label class="required fw-bold fs-6 mb-2">WP API URL</label>
    <input type="url" name="wp_api_url"
           class="form-control form-control-solid"
           value="{{ old('wp_api_url', $data->wp_api_url ?? '') }}" required>
</div>

<div class="fv-row mb-7">
    <label class="required fw-bold fs-6 mb-2">WP Username</label>
    <input type="text" name="wp_username"
           class="form-control form-control-solid"
           value="{{ old('wp_username', $data->wp_username ?? '') }}" required>
</div>

<div class="fv-row mb-7">
    <label class="required fw-bold fs-6 mb-2">WP Password</label>
    <input type="text" name="wp_password"
           class="form-control form-control-solid"
           value="{{ old('wp_password', $data->wp_password ?? '') }}" required>
</div>

<div class="fv-row mb-7">
    <label class="required fw-bold fs-6 mb-2">AI Provider</label>
    <select name="ai_provider" class="form-select form-select-solid">
        <option value="chatgpt"  @selected(isset($data) && $data->ai_provider == 'chatgpt')>ChatGPT</option>
        <option value="gemini"   @selected(isset($data) && $data->ai_provider == 'gemini')>Gemini</option>
        <option value="deepseek" @selected(isset($data) && $data->ai_provider == 'deepseek')>DeepSeek</option>
    </select>
</div>

<div class="fv-row mb-7">
    <label class="required fw-bold fs-6 mb-2">AI API Key</label>
    <input type="text" name="ai_api_key"
           class="form-control form-control-solid"
           value="{{ old('ai_api_key', $data->ai_api_key ?? '') }}" required>
</div>


<div class="fv-row mb-7">
    <div class="form-check form-switch form-check-custom form-check-solid">
        <label class="form-check-label">Active</label>

        <input type="hidden" name="is_active" value="0">
        <input class="form-check-input" type="checkbox" name="is_active"
               value="1" @checked(isset($data) && $data->is_active)>
    </div>
</div>
