@extends('layout.layout')

@php
    $route = 'articles';
@endphp

@section('title', 'Preview Article')

@section('header')
    <h1 class="text-dark fw-bolder my-0 fs-2">
        معاينة المقال رقم #{{ $article->id }}
    </h1>

    <ul class="breadcrumb fw-bold fs-base my-1">
        <li class="breadcrumb-item"><a href="{{ url('/') }}" class="text-muted">Dashboard</a></li>
        <li class="breadcrumb-item">
            <a href="{{ route('articles.index', $article->batch_id) }}" class="text-muted">Articles</a>
        </li>
        <li class="breadcrumb-item">Preview</li>
    </ul>
@endsection

@section('content')

<div class="container-xxl">

    <div class="card p-10">

        <h2 class="fw-bold">{{ $article->final_title ?? $article->source_title }}</h2>
        <p><strong>Keyword:</strong> {{ $article->focus_keyword }}</p>

        <hr>

        <h3 class="fw-bolder">المقدمة:</h3>
        <div class="mb-5">{!! nl2br(e($article->intro)) !!}</div>

        <h3 class="fw-bolder">المحتوى الداخلي:</h3>
        <div class="mb-5">{!! $article->body !!}</div>

        <h3 class="fw-bolder">الخاتمة:</h3>
        <div class="mb-5">{!! nl2br(e($article->conclusion)) !!}</div>

        <hr>

        <h3 class="fw-bolder">SEO Data</h3>
        <p><strong>Meta Title:</strong> {{ $article->meta_title }}</p>
        <p><strong>Meta Description:</strong> {{ $article->meta_description }}</p>

        <h4 class="fw-bolder mt-5">Schema JSON</h4>
        <pre class="bg-light p-5 rounded">{{ json_encode($article->schema_json, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE) }}</pre>

        <h4 class="fw-bolder mt-5">Internal Links</h4>
        <pre class="bg-light p-5 rounded">{{ json_encode($article->internal_links, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE) }}</pre>

        <h4 class="fw-bolder mt-5">External Sources</h4>
        <pre class="bg-light p-5 rounded">{{ json_encode($article->external_sources, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE) }}</pre>

    </div>

</div>

@endsection
