<div class="fv-row mb-7">
    <label class="required fw-bold fs-6 mb-2">{{ __('lang.name') }}</label>
    <input type="text" name="name"
           class="form-control form-control-solid mb-3 mb-lg-0"
           value="{{ old('name', $data->name ?? '') }}"
           required />
</div>

<div class="fv-row mb-7">
    <label class="required fw-bold fs-6 mb-2">{{ __('lang.email') }}</label>
    <input type="email" name="email"
           class="form-control form-control-solid mb-3 mb-lg-0"
           value="{{ old('email', $data->email ?? '') }}"
           required />
</div>

<div class="fv-row mb-7">
    <label class="required fw-bold fs-6 mb-2">{{ __('lang.type') }}</label>
    <select name="role" class="form-select form-select-solid mb-3 mb-lg-0">
        <option value="admin" {{ isset($data) && $data->role == 'admin' ? 'selected' : '' }}>admin</option>
        <option value="employee" {{ isset($data) && $data->role == 'employee' ? 'selected' : '' }}>employee</option>
    </select>
</div>

<div class="fv-row mb-7">
    <label class="fw-bold fs-6 mb-2">
        {{ isset($data) ? __('lang.password') : __('lang.password') }}
    </label>

    <input type="password" name="password"
           class="form-control form-control-solid mb-3 mb-lg-0"
           placeholder="{{ isset($data) ? __('lang.password') : '' }}"
           @if(!isset($data)) required @endif />
</div>

<div class="fv-row mb-7">
    <div class="form-check form-switch form-check-custom form-check-solid">
        <label class="form-check-label fw-bold fs-6" for="user_active_switch">
            {{ __('lang.active') }}
        </label>

        <input type="hidden" name="is_active" value="0">
        <input class="form-check-input"
               id="user_active_switch"
               type="checkbox"
               name="is_active"
               value="1"
               @if(isset($data) && $data->is_active) checked @endif />
    </div>
</div>
