@extends('layout.layout')

@php
    $route = 'articles';
@endphp

@section('title', __('lang.edit'))

@section('header')
    <h1 class="text-dark fw-bolder my-0 fs-2">
        {{ __('lang.edit') }} {{ __('lang.articles') }} #{{ $data->id }}
    </h1>

    <ul class="breadcrumb fw-bold fs-base my-1">
        <li class="breadcrumb-item"><a href="{{ url('/') }}" class="text-muted">{{ __('lang.Dashboard') }}</a></li>
        <li class="breadcrumb-item">
            <a href="{{ route('articles.index', $data->batch_id) }}" class="text-muted">{{ __('lang.articles') }}</a>
        </li>
        <li class="breadcrumb-item">{{ __('lang.edit') }}</li>
    </ul>
@endsection

@section('content')

<div class="container-xxl">

    <div class="card p-10">

        <form action="{{ route('articles.update', [$data->batch_id, $data->id]) }}" method="POST">
            @csrf

            {{-- Source Information --}}
            <h3 class="mb-5">{{ __('lang.source') }} {{ __('lang.information') }}</h3>
            
            <div class="row mb-10">
                <div class="col-md-6">
                    <label class="fw-bold">{{ __('lang.source') }} {{ __('lang.title') }}</label>
                    <input type="text" name="source_title" class="form-control"
                           value="{{ old('source_title', $data->source_title) }}" readonly>
                </div>
                <div class="col-md-6">
                    <label class="fw-bold">{{ __('lang.focus_keyword') }}</label>
                    <input type="text" name="focus_keyword" class="form-control"
                           value="{{ old('focus_keyword', $data->focus_keyword) }}">
                </div>
            </div>

            <div class="mb-10">
                <label class="fw-bold">LSI {{ __('lang.keyword') }}s</label>
                <textarea name="lsi_keywords" rows="3" class="form-control">{{ is_array($data->lsi_keywords) ? implode(', ', $data->lsi_keywords) : $data->lsi_keywords }}</textarea>
                <small class="text-muted">{{ __('lang.separate_with_comma') }}</small>
            </div>

            <hr class="my-10">

            {{-- Article Content --}}
            <h3 class="mb-5">{{ __('lang.content') }}</h3>

            <div class="mb-10">
                <label class="fw-bold">{{ __('lang.final_title') }}</label>
                <input type="text" name="final_title" class="form-control"
                       value="{{ old('final_title', $data->final_title) }}">
            </div>

            <div class="mb-10">
                <label class="fw-bold">Slug</label>
                <input type="text" name="slug" class="form-control"
                       value="{{ old('slug', $data->slug) }}">
            </div>

            <div class="mb-10">
                <label class="fw-bold">{{ __('lang.intro') }}</label>
                <textarea name="intro" rows="5" class="form-control">{{ old('intro', $data->intro) }}</textarea>
            </div>

            <div class="mb-10">
                <label class="fw-bold">{{ __('lang.body') }}</label>
                <textarea name="body" id="bodyEditor" rows="12" class="form-control">{{ old('body', $data->body) }}</textarea>
            </div>

            <div class="mb-10">
                <label class="fw-bold">{{ __('lang.conclusion') }}</label>
                <textarea name="conclusion" rows="5" class="form-control">{{ old('conclusion', $data->conclusion) }}</textarea>
            </div>

            <hr class="my-10">

            {{-- SEO Settings --}}
            <h3 class="mb-5">{{ __('lang.seo_settings') }}</h3>

            <div class="mb-10">
                <label class="fw-bold">Meta {{ __('lang.title') }}</label>
                <input type="text" name="meta_title" class="form-control"
                       value="{{ old('meta_title', $data->meta_title) }}">
            </div>

            <div class="mb-10">
                <label class="fw-bold">Meta {{ __('lang.description') }}</label>
                <textarea name="meta_description" rows="3" class="form-control">{{ old('meta_description', $data->meta_description) }}</textarea>
            </div>

            <div class="row mb-10">
                <div class="col-md-6">
                    <label class="fw-bold">OG {{ __('lang.title') }}</label>
                    <input type="text" name="og_title" class="form-control"
                           value="{{ old('og_title', $data->og_title) }}">
                </div>
                <div class="col-md-6">
                    <label class="fw-bold">OG {{ __('lang.description') }}</label>
                    <input type="text" name="og_description" class="form-control"
                           value="{{ old('og_description', $data->og_description) }}">
                </div>
            </div>

            <div class="mb-10">
                <label class="fw-bold">Schema JSON</label>
                <textarea name="schema_json" rows="8" class="form-control">{{ old('schema_json', is_array($data->schema_json) ? json_encode($data->schema_json, JSON_PRETTY_PRINT) : $data->schema_json) }}</textarea>
            </div>

            <hr class="my-10">

            {{-- WordPress Settings --}}
            <h3 class="mb-5">WordPress {{ __('lang.settings') }}</h3>

            <div class="row mb-10">
                <div class="col-md-6">
                    <label class="fw-bold">WordPress {{ __('lang.category') }} ID</label>
                    <input type="number" name="wp_category_id" class="form-control"
                           value="{{ old('wp_category_id', $data->wp_category_id) }}">
                </div>
                <div class="col-md-6">
                    <label class="fw-bold">WordPress {{ __('lang.status') }}</label>
                    <select name="wp_status" class="form-control">
                        <option value="draft" {{ $data->wp_status == 'draft' ? 'selected' : '' }}>Draft</option>
                        <option value="publish" {{ $data->wp_status == 'publish' ? 'selected' : '' }}>Publish</option>
                        <option value="pending" {{ $data->wp_status == 'pending' ? 'selected' : '' }}>Pending</option>
                    </select>
                </div>
            </div>

            <div class="mb-10">
                <label class="fw-bold">{{ __('lang.cover_image') }} URL</label>
                <input type="url" name="cover_image_url" class="form-control"
                       value="{{ old('cover_image_url', $data->cover_image_url) }}">
            </div>

            <hr class="my-10">

            {{-- Design Colors --}}
            <h3 class="mb-5">{{ __('lang.design_colors') }}</h3>

            <div class="row mb-10">
                <div class="col-md-4">
                    <label class="fw-bold">{{ __('lang.suggest_link_color') }}</label>
                    <input type="color" name="suggest_link_color" class="form-control form-control-color"
                           value="{{ old('suggest_link_color', $data->suggest_link_color ?? '#0000FF') }}">
                </div>
                <div class="col-md-4">
                    <label class="fw-bold">{{ __('lang.suggest_keyword_color') }}</label>
                    <input type="color" name="suggest_keyword_color" class="form-control form-control-color"
                           value="{{ old('suggest_keyword_color', $data->suggest_keyword_color ?? '#FF0000') }}">
                </div>
                <div class="col-md-4">
                    <label class="fw-bold">{{ __('lang.border_color') }}</label>
                    <input type="color" name="border_color" class="form-control form-control-color"
                           value="{{ old('border_color', $data->border_color ?? '#000000') }}">
                </div>
            </div>

            <div class="row mb-10">
                <div class="col-md-6">
                    <label class="fw-bold">{{ __('lang.gradient_first_color') }}</label>
                    <input type="color" name="gradient_first_color" class="form-control form-control-color"
                           value="{{ old('gradient_first_color', $data->gradient_first_color ?? '#FFFFFF') }}">
                </div>
                <div class="col-md-6">
                    <label class="fw-bold">{{ __('lang.gradient_second_color') }}</label>
                    <input type="color" name="gradient_second_color" class="form-control form-control-color"
                           value="{{ old('gradient_second_color', $data->gradient_second_color ?? '#CCCCCC') }}">
                </div>
            </div>

            <hr class="my-10">

            {{-- Links & Sources --}}
            <h3 class="mb-5">{{ __('lang.links_sources') }}</h3>

            <div class="mb-10">
                <label class="fw-bold">{{ __('lang.internal_links') }}</label>
                <textarea name="internal_links" rows="4" class="form-control">{{ old('internal_links', is_array($data->internal_links) ? json_encode($data->internal_links, JSON_PRETTY_PRINT) : $data->internal_links) }}</textarea>
                <small class="text-muted">JSON format</small>
            </div>

            <div class="mb-10">
                <label class="fw-bold">{{ __('lang.external_sources') }}</label>
                <textarea name="external_sources" rows="4" class="form-control">{{ old('external_sources', is_array($data->external_sources) ? json_encode($data->external_sources, JSON_PRETTY_PRINT) : $data->external_sources) }}</textarea>
                <small class="text-muted">JSON format</small>
            </div>

            <hr class="my-10">

            <div class="text-end">
                <a href="{{ route('articles.index', $data->batch_id) }}" class="btn btn-light me-3">{{ __('lang.cancel') }}</a>
                <button type="submit" class="btn btn-primary">{{ __('lang.save') }}</button>
            </div>

        </form>

    </div>

</div>

@endsection

@section('script')
<script src="https://cdn.ckeditor.com/4.21.0/full/ckeditor.js"></script>

<script>
    CKEDITOR.replace('bodyEditor');
</script>
@endsection
