@extends('layout.layout')

@php
    $route = 'article_batches';
@endphp

@section('title', __('lang.article_batches'))

@section('header')
    <h1 class="text-dark fw-bolder my-0 fs-2">{{ __('lang.article_batches') }}</h1>

    <ul class="breadcrumb fw-bold fs-base my-1">
        <li class="breadcrumb-item">
            <a href="{{ url('/') }}" class="text-muted">{{ __('lang.Dashboard') }}</a>
        </li>
        <li class="breadcrumb-item">{{ __('lang.article_batches') }}</li>
    </ul>
@endsection

@section('content')

<div id="kt_content_container" class="flex-column-fluid align-items-start container-xxl">

    <div class="content flex-row-fluid" id="kt_content">

        <div class="card">

            <div class="card-body pt-0">

                <div class="add_button1"></div>

                <div class="table-responsive">

                    <table class="table align-middle table-row-bordered text-start fs-4 gy-5"
                           id="article_batches_table">

                        <thead>
                        <tr class="bg-secondary text-dark fw-bolder fs-5 text-capitalize gs-0">

                            <th class="w-10px pe-2">
                                <div class="form-check form-check-sm form-check-custom form-check-solid me-3">
                                    <input class="form-check-input" type="checkbox"
                                           data-kt-check="true"
                                           data-kt-check-target="#article_batches_table .checkbox"
                                           value="1"/>
                                </div>
                            </th>

                            <th class="min-w-125px">{{ __('lang.site') }}</th>
                            <th class="min-w-125px">{{ __('lang.file_name') }}</th>
                            <th class="min-w-125px">{{ __('lang.rows_count') }}</th>
                            <th class="min-w-125px">{{ __('lang.uploaded_by') }}</th>
                            <th class="min-w-125px">{{ __('lang.status') }}</th>
                            <th class="min-w-125px">{{ __('lang.Actions') }}</th>

                        </tr>
                        </thead>

                    </table>

                </div>

            </div>

        </div>

    </div>

</div>

@endsection


@section('script')
<script src="{{ asset('assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>

<script>

    $(function () {

        var table = $('#article_batches_table').DataTable({
            processing: true,
            serverSide: true,
            autoWidth: true,
            aaSorting: [],
            dom:
                "<'card-header border-0 p-0 pt-6'<'card-title' <'d-flex align-items-center position-relative my-1'f>>" +
                "<'card-toolbar' <'d-flex justify-content-end add_button'B>>" +
                "r>" +
                "<'row'l>" +
                "t" +
                "<'row'<'col-md-5'i><'col-md-7'p>>",

            language: {
                search: '<i class="fa fa-search"></i>',
                searchPlaceholder: '{{ __("lang.search") }}',
            },

            ajax: {
                url: "{{ route($route.'.datatable') }}",
                data: function (d) {
                    @if((Request::get('site_id')))
                    d.site_id = {{Request::get('site_id')}};
                    @endif
                }
            },

            columns: [
                { data: 'checkbox', name: 'checkbox' },
                { data: 'site', name: 'site' },
                { data: 'original_filename', name: 'original_filename' },
                { data: 'rows_count', name: 'rows_count' },
                { data: 'uploaded_by', name: 'uploaded_by' },
                { data: 'status', name: 'status' },
                { data: 'actions', name: 'actions', orderable: false, searchable: false },
            ],

            buttons: [
                {
                    extend: 'excel',
                    className: 'btn btn-primary',
                    text: '<i class="bi bi-file-earmark-spreadsheet-fill fs-2x"></i>',
                },
                {
                    extend: 'print',
                    className: 'btn btn-primary',
                    text: '<i class="bi bi-printer-fill fs-2x"></i>',
                }
            ]

        });

        // Load Add Button
        $.ajax({
            url: "{{ route($route.'.add-button') }}",
            success: function (data) {
                $('.add_button1').html(data);
            }
        });

    });

</script>
@endsection
