@extends('layout.layout')
@section('title',__('lang.article_logs'))
@section('css')
@endsection
@section('content')
    <!--begin::Post-->
    <div class="post d-flex flex-column-fluid" id="kt_post">
        <!--begin::Container-->
        <div id="kt_content_container" class="container-xxl">
            <!--begin::Card-->
            <div class="card">
                <!--begin::Card header-->
                <div class="card-header border-0 pt-6">
                    <!--begin::Card title-->
                    <div class="card-title">
                        <h2>{{__('lang.show')}}</h2>
                    </div>
                </div>
                <!--end::Card header-->
                <!--begin::Card body-->
                <div class="card-body py-4">
                    <div class="row">
                        <div class="col-md-6">
                            <label class="form-label">{{__('lang.article')}}</label>
                            <input type="text" class="form-control form-control-solid" value="{{ $data->article ? $data->article->title : '-' }}" readonly/>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">{{__('lang.level')}}</label>
                            <input type="text" class="form-control form-control-solid" value="{{ $data->level }}" readonly/>
                        </div>
                    </div>
                    <div class="row mt-5">
                        <div class="col-md-6">
                            <label class="form-label">{{__('lang.action')}}</label>
                            <input type="text" class="form-control form-control-solid" value="{{ $data->action }}" readonly/>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">{{__('lang.created_at')}}</label>
                            <input type="text" class="form-control form-control-solid" value="{{ $data->created_at }}" readonly/>
                        </div>
                    </div>
                    <div class="row mt-5">
                        <div class="col-md-12">
                            <label class="form-label">{{__('lang.message')}}</label>
                            <textarea class="form-control form-control-solid" rows="3" readonly>{{ $data->message }}</textarea>
                        </div>
                    </div>
                    <div class="row mt-5">
                        <div class="col-md-12">
                            <label class="form-label">{{__('lang.payload')}}</label>
                            <pre class="form-control form-control-solid" style="height: auto;">{{ json_encode($data->payload, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) }}</pre>
                        </div>
                    </div>
                    <div class="row mt-5">
                        <div class="col-md-12">
                            <a href="{{ route('article-logs.index') }}" class="btn btn-secondary">{{__('lang.back')}}</a>
                        </div>
                    </div>
                </div>
                <!--end::Card body-->
            </div>
            <!--end::Card-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::Post-->
@endsection
