<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Candidate extends Model
{
    protected $fillable = [
        'name',
        'image',
    ];

    public function voters()
    {
        return $this->hasMany(Voter::class);
    }

      public function getImageAttribute($image)
    {
        if (!empty($image)) {
            // return Storage::disk('s3')->url('uploads/clients_images/' . $image);
           return asset('uploads/Candidate') . '/' . $image;
        }
        return asset('defaults/user_default.png');
    }

    public function setImageAttribute($image)
    {
        if (is_file($image)) {
            $img_name = 'user_' . time() . random_int(0000, 9999) . '.' . $image->getClientOriginalExtension();
            // $image->storeAs('uploads/clients_images/', $img_name, 's3');
           $image->move(public_path('/uploads/Candidate/'), $img_name);
            $this->attributes['image'] = $img_name;
        }else{
            $this->attributes['image'] = $image;
        }
    }
}
