<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Tymon\JWTAuth\Facades\JWTAuth;
use App\Models\User;
use App\Http\Requests\Api\Auth\RegisterRequest;
use App\Http\Requests\Api\Auth\VerifyOtpRequest;
use App\Http\Resources\Api\UserResource;
use App\Http\Requests\Api\UserLoginRequest;

class AuthController extends Controller
{

       public function login(UserLoginRequest $request)
    {
        $data = $request->validated();
        $credentials = $request->only('username', 'password');
        $username = $request->username;
    
        // حاول تسجل دخول كشركة أولاً
     
        // لو فشل تسجيل دخول الشركة، حاول كمستخدم
        if ($token = Auth::guard('api')->attempt($credentials)) {
            $user = Auth::guard('api')->user();

        
            // if ($user->status == 'inactive') {
            //     auth('user')->logout();
            //     return msg(false, trans('lang.user_inactive'), failed());
            // }


            return msgdata(true, trans('lang.login_s'), [
                'token' => $token,
                'client_data' => UserResource::make($user),
            ], success());
        }

        // لو فشل الاثنين
        return msg(false, trans('lang.invalid_account'), failed());
    }



    public function logout()
    {
        auth()->logout();
        return msgdata(true, trans('lang.logout_success'));
    }

    public function refresh()
    {
        return msgdata(true, trans('lang.token_refreshed'), [
            'token' => auth()->refresh(),
        ]);
    }

    public function me()
    {
        return msgdata(true, trans('lang.data_retrieved_successfully'), new UserResource(auth()->user()));
    }
    public function updateProfile(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'first_name'   => 'required|string|max:255',
            'middle_name'  => 'required|string|max:255',
            'last_name'    => 'required|string|max:255',
            'email' => 'required|email|unique:users,email,' . Auth::guard('api')->id(),
    //            'phone'        => 'required|regex:/^9665[0-9]{8}$/|unique:users,phone,'.Auth::guard('api')->id(),
            'birth_day'    => 'nullable|date',
            'city_id'      => 'nullable|exists:cities,id',
        ]);

        if ($validator->fails()) {
            return msgdata(false, trans('lang.there_is_some_errors'), $validator->errors()->all(), 422);
        }

      $data =  User::where('id',Auth::guard('api')->id())->update([
            'first_name'=>$request->first_name,
            'middle_name'=>$request->middle_name,
            'last_name'=>$request->last_name,
            'email'=>$request->email,
            'birth_day'=>$request->birth_day,
            'city_id'=>$request->city_id,
        ]);
        return msgdata(true, trans('lang.data_retrieved_successfully'), new UserResource(Auth::guard('api')->user()));
    }

    public function deleteAccount(Request $request){

        User::where('id',Auth::guard('api')->id())->delete();
        return msgdata(true, trans('lang.deleted_s'), (object)[], 200);


    }
}
