<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Models\Candidate;
use App\Models\Voter;

class ApiController extends Controller
{
    public function candidates(){

        if(Auth::guard('api')->user()->role == 'employee'){
            $data = Candidate::OrderBy('id','desc')->where('created_by',Auth::guard('api')->user()->id)->paginate(8);
        }else{
           $data = Candidate::OrderBy('id','desc')->paginate(8);
        }
         return msgdata(true, trans('lang.data_display_success'), $data, success());

    }
    public function voters(){

        if(Auth::guard('api')->user()->role == 'employee'){
            $data = Voter::OrderBy('id','desc')->where('created_by',Auth::guard('api')->user()->id)->paginate(8);
        }else{
           $data = Voter::OrderBy('id','desc')->paginate(8);
        }
         return msgdata(true, trans('lang.data_display_success'), $data, success());

    }

    public function storeVoter(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'national_id' => 'required|numeric|unique:voters,national_id',
            'candidate_id' => 'nullable|exists:candidates,id',
        ]);

        if ($validator->fails()) {
            return msgdata(false, trans('lang.there_is_some_errors'), $validator->errors()->all(), 422);
        }

        $voter = Voter::create([
            'name' => $request->name,
            'national_id' => $request->national_id,
            'candidate_id' => $request->candidate_id,
            'created_by' => Auth::guard('api')->id(),
            'is_vote' => false,
        ]);

        return msgdata(true, trans('lang.added_s'), $voter, success());
    }

    public function confirm(Request $request, Voter $voter)
    {
        if ($voter->is_vote) {
             return msg(false, trans('lang.already_confirmed'), failed());
        }

        $voter->update([
            'is_vote' => true,
            'confirm_by' => Auth::guard('api')->id(),
        ]);

        return msgdata(true, trans('lang.confirmed_s'), $voter, success());
    }
}
